'''
create_json_file.py
'''

import os
import sys
import json


def main():
    '''
    main
    :return:
    '''
    base_dir = os.path.realpath(sys.argv[1])
    dir_name = os.path.split(base_dir)[1]
    if not os.path.exists(dir_name):
        os.mkdir(dir_name)
    for select_type in os.listdir(base_dir):
        result_dict = {}
        for instance_name in os.listdir(os.path.join(base_dir, select_type)):
            result_dict[instance_name] = {}
            with open(os.path.join(base_dir, select_type, instance_name), "rb") as _f:
                result_dict[instance_name] = json.load(_f)
        with open(os.path.join(dir_name, "%s.json" % select_type), "w") as json_f:
            json.dump(result_dict, json_f)


if __name__ == '__main__':
    main()

