import os
import sys
import json
sys.path.append("..")
from exp_imp_data import get_db_names
from exp_imp_data import py_zenith
from pyscripts import get_db_pass

INSTANCE_NAME = sys.argv[1]
MACHINE_IP = sys.argv[2]
PORT = sys.argv[3]
DB_TYPE = sys.argv[4]
DIR_NAME = sys.argv[5]


def main():
    db_names = get_db_names.get_db_list()
    db_name = db_names[0]
    db_info = get_db_pass.main(INSTANCE_NAME, db_name, DB_TYPE).split(",")[-1]
    zenith_connect = py_zenith.Zenith(
        host=MACHINE_IP,
        username=db_name,
        password=db_info,
        port=str(PORT))

    columns_dict = {
        "DB_TAB_COLUMNS": ['owner', 'table_name', 'column_name', 'data_type', 'data_default', 'nullable'],
        "DB_INDEXES": ['owner', 'table_name', 'columns', 'index_name'],
        "DB_PROCEDURES": ['owner', 'object_name', 'object_type', 'source'],
        "PRIMARY_KEY": ['owner', 'table_name', 'columns']
    }
    sql_dict = {
        "DB_TAB_COLUMNS": "SELECT %s FROM sys.db_tab_columns WHERE owner NOT IN('SYS','HOFSDB1','FMDB','SYSLOGDB') "
                          "AND table_name NOT REGEXP 'T_NOTIFY|TB_' ORDER BY owner,table_name,column_name"
                          % ",".join(columns_dict["DB_TAB_COLUMNS"]),
        "DB_INDEXES": "SELECT %s FROM db_indexes WHERE owner "
                      "NOT IN('SYS','CMDBCORESVRDB','INVMIRRORDB','DSOEMANAGEMENTDB','SYSLOGDB','FMDB') "
                      "AND index_name NOT REGEXP 'PK_SYS_|UQ_SYS_|UNIQUE_INDEX_TB_' "
                      "AND columns not REGEXP 'NEID, JSON_VALUE' ORDER BY owner,table_name,index_name,columns"
                      % ",".join(columns_dict["DB_INDEXES"]),
        "DB_PROCEDURES": "SELECT %s FROM sys.db_procedures WHERE owner "
                         "NOT IN('SYS','CMDBCORESVRDB','INVMIRRORDB','DSOEMANAGEMENTDB','SYSLOGDB','FMDB') "
                         "ORDER BY owner,object_type,object_name"
                         % ",".join(columns_dict["DB_PROCEDURES"]),
    }

    for select_type, sql in sql_dict.items():
        print(sql)
        columns = columns_dict[select_type]
        get_data(zenith_connect, sql, select_type, columns)


def get_data(zenith_connect, sql, select_type, columns):
    full_dir = os.path.join(DIR_NAME, select_type)
    if not os.path.exists(full_dir):
        os.makedirs(full_dir)
    result = zenith_connect.select(sql)
    result_dic = {}
    for row in result:
        db_name = row[0]
        # DB_PROCEDURES来说，就是object_name
        table_name = row[1]
        if select_type == "DB_INDEXES" or select_type == "PRIMARY_KEY":
            # 字段顺序处理
            row = list(row)
            last_data = [value.strip() for value in row[2].split(",")]
            last_data.sort()
            row[2] = ",".join(last_data)

        elif select_type == "DB_PROCEDURES":
            row = [data.decode() if isinstance(data, bytes) else data for data in row]
        if db_name not in result_dic:
            result_dic[db_name] = {}
        if table_name not in result_dic[db_name]:
            result_dic[db_name][table_name] = {}
        if select_type == "DB_TAB_COLUMNS" or select_type == "DB_INDEXES":
            column_name = row[2]
            if column_name not in result_dic[db_name][table_name]:
                result_dic[db_name][table_name][column_name] = {}
                result_dic[db_name][table_name][column_name] = dict(zip(columns, row))
        else:
            result_dic[db_name][table_name] = dict(zip(columns, row))
    with open(os.path.join(full_dir, INSTANCE_NAME), "w") as _f:
        json.dump(result_dic, _f)


if __name__ == '__main__':
    if INSTANCE_NAME != "managedbsvr":
        main()

