#!/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
script_name=`basename $0`
UPGRADE=${1}

print_log()
{
    local content=$*
    log_filename="$CUR_PATH/update_nw.log"
    echo $log_filename 
    CURTIME=`date '+%Y-%m-%d %H:%M:%S'`
    echo "Log: $CURTIME $$ $script_name : $content" | tee -a $log_filename
}

#获取数据库信息（query database)
get_dbip_port() {
    dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Master`

    if [ -z "$dbinfo" ]
    then
        print_log "$LINENO single db instance"
        dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"`
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_instance=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=''
        db_type=`echo $dbinfo|awk '{print $9}'`
    else
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_instance=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Slave|awk '{print $3}'`
        db_type=`echo $dbinfo|awk '{print $9}'`
    fi

    
}


main(){

    table_structrue="/opt/oss/get_table_structure/${UPGRADE}"
    if [ -d ${table_structrue} ]
    then
        rm -rf ${table_structrue}
    fi


    for instance_name_ip in `sudo -u dbuser ls /opt/zenith/data`
    do
        instance_name_array=(${instance_name_ip//-/ })
        instance_name=${instance_name_array[0]}
        echo ${instance_name}
        #运行函数：获取数据库ip,port, admin password
        get_dbip_port ${instance_name}
        . /opt/oss/manager/agent/bin/engr_profile.sh; python ${CUR_PATH}/get_table_info.py ${instance_name} ${MACHINE_IP} ${port} zenith ${table_structrue}
    done

    . /opt/oss/manager/agent/bin/engr_profile.sh; python ${CUR_PATH}/create_json_file.py ${table_structrue}
}

main


