'''
compare
'''

import os
import sys
sys.path.append("..")
import json
import shutil
import subprocess
from openpyxl import Workbook
from pyscripts import updatenodes_NCE

CUR_PATH = os.path.dirname(os.path.abspath(sys.argv[0]))
print(CUR_PATH)

def read_base_line(product_name):
    '''
    读取特性 - 微服务 基线文件
    :param product_name:
    :return: optional_dict: 可选的特性与微服务关系
             optional_lowercase: 可选特性小写 与 原值的关系(特性匹配时使用小写)
             mandatory_services: 必装微服务
    '''
    file_name = "%s_baseline.json" % product_name
    with open(file_name, "rb") as _f:
        json_base = json.load(_f)
    optional_dict = {}
    optional_lowercase = {}
    for dic in json_base["Optional"]:
        feature = dic["feature"]
        services = dic["services"]
        optional_dict[feature] = services
        optional_lowercase[feature.lower()] = feature
    mandatory_services = []
    for service_name in json_base["Mandatory"]["services"]:
        mandatory_services.append(service_name)
    return optional_dict, optional_lowercase, mandatory_services



def get_feature(product_name, tenant_name):
    '''
    获取特性
    :param product_name:
    :return:
    '''
    if product_name == "product":
        dir_name = os.path.join(CUR_PATH, product_name)
        if os.path.exists(dir_name):
            shutil.rmtree(dir_name)
        os.makedirs(dir_name)
        command = "/opt/oss/manager/tools/resmgr/queryproduct.sh -pn %s -output %s" % (tenant_name, dir_name)
        print(command)
        result = subprocess.call(command.split())
        if result == 0:
            with open(os.path.join(dir_name, "product_%s.json" % tenant_name), "rb") as _f:
                json_info = json.load(_f)
            return json_info["productext"]["features"].strip(";").split(";")
        else:
            raise ValueError("queryproduct failed")
    else:
        return []


def get_service(tenant_name):
    service_dict = {}
    _ips = updatenodes_NCE.main()
    for _ip_str in _ips.split(","):
        _ip = _ip_str.split(":9094")[0]
        command = 'ssh ossadm@%s "ls /opt/oss/%s/apps"' % (_ip, tenant_name)
        result = subprocess.getoutput(command)
        for index, service_name in enumerate(result.split("\n")):
                service_name = service_name.strip()
                if service_name and "Authorized users only" not in service_name:
                    if "DeployAgent".lower() in service_name.lower():
                        service_name = "DeployAgent"
                    service_dict[service_name.lower()] = service_name
    return service_dict


def get_tenant_name(product_name):
    if product_name == "product":
        if os.path.exists("/opt/oss/NCECOMMONE/apps"):
            tenant_name = "NCECOMMONE"
        else:
            tenant_name = "NCE"
    else:
        tenant_name = product_name
    return tenant_name


def main(product_name, tenant_name):
    '''
    1、获取升级后特性列表
    2、获取升级后微服务列表
    3、获取基线 可预先特性与微服务组合的关系、必装微服务列表
    4、遍历升级后特性：
        1、如果特性是选装特性，就需要对比升级后微服务中是否还有特性对应的微服务，
           如果有，加入已被对比的微服务集合(compared_service)；如果不存在 加入 result_list
        2、如果特性不是选装特性，跳过
    6、遍历基线的必装微服务，如果存在，加入已被对比的微服务集合(compared_service)；如果不存在 加入 result_list
    7、通过比较 升级后微服务列表 和 已被对比的微服务集合，升级后列表多出的就是新增的微服务
    :param product_name:
    :return:
    '''
    # 获取升级后特性列表
    upgrade_features_list = get_feature(product_name, tenant_name)
    upgrade_features_lower = set([upgrade_feature.lower() for upgrade_feature in upgrade_features_list])
    # 已对比的微服务
    compared_service = set()
    # 结果列表
    result_list = []
    # 必装特性（升级后特性 - 基线可选特性）
    mandatory_features_list = []
    # 获取升级后微服务列表
    upgrade_service_dict = get_service(tenant_name)
    upgrade_service_set = set(upgrade_service_dict.keys())
    # 获取基线 可选特性与微服务关系、必装微服务列表
    optional_dict, optional_lowercase, mandatory_services = read_base_line(product_name)

    # 遍历升级后特性：
    # 1、如果特性是选装特性，就需要对比升级后微服务中是否还有特性对应的微服务，
    #    如果有，加入已被对比的微服务集合(compared_service)；如果不存在加入result_list
    # 2、如果特性不是选装特性，跳过
    for upgrade_feature_lower in upgrade_features_lower:
        if upgrade_feature_lower in optional_lowercase:
            for service_name in optional_dict[optional_lowercase[upgrade_feature_lower]]:
                if service_name.lower() not in upgrade_service_dict:
                    result_list.append(["缺少微服务", optional_lowercase[upgrade_feature_lower], service_name])
                else:
                    compared_service.add(service_name.lower())
        else:
            mandatory_features_list.append(upgrade_feature_lower)

    # 遍历基线的必装微服务，如果存在，加入已比较列表；如果不存在 加入 result_list
    for service_name in mandatory_services:
        if service_name.lower() in upgrade_service_set:
            compared_service.add(service_name.lower())
        else:
            result_list.append(["缺少微服务", "必装", service_name])

    # 通过比较 升级后微服务列表 和 已被对比的微服务集合，升级后列表多出的就是新增的微服务
    add_service = upgrade_service_set.difference(compared_service)
    for service_name in add_service:
        result_list.append(["多出微服务", "", upgrade_service_dict[service_name]])

    upgrade_features_list.sort()
    mandatory_features_list.sort()
    return result_list, upgrade_features_list, mandatory_features_list


def main2(service_report_dir):
    '''
    :param service_report_dir: 报告存放目录
    :return:
    '''
    result = {}
    for product_name in ["product", "manager"]:
        file_name = "%s_baseline.json" % product_name
        if os.path.exists(file_name):
            tenant_name = get_tenant_name(product_name)
            result[product_name] = main(product_name, tenant_name)

    write_excel(result, service_report_dir)


def write_excel(result, service_report_dir):
    '''
    :param result: 结果
    :param service_report_dir: 报告存放目录
    :return:
    '''
    has_difference = False
    # 打开工作表格
    wb = Workbook()
    # 删除默认的工作表格
    wb.remove(wb.active)
    title = ["变更类型", "特性", "微服务"]
    for product_name, result in result.items():
        result_list = result[0]
        if result_list:
            has_difference = True
        result_list.sort(key=lambda key: key[0])
        upgrade_features_list = result[1]
        mandatory_features_list = result[2]
        sheet = wb.create_sheet("%s,升级相对于安装" % product_name)
        sheet.append(["升级后特性",  ",".join(upgrade_features_list)])
        sheet.append(["必装特性 = 升级后特性 - 基线可选特性", ",".join(mandatory_features_list)])
        sheet.append(title)
        for row in result_list:
            sheet.append(row)
    if has_difference:
        wb.save(os.path.join(service_report_dir, "service_difference_report.xlsx"))
    else:
        wb.save(os.path.join(service_report_dir, "no_difference.xlsx"))


if __name__ == '__main__':
    pass
    print(updatenodes_NCE.main())


