#!/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
DB_TYPE=zenith
save_container_list_file=${CUR_PATH}/container_list_file.json
temporary_dir=$(sh ${CUR_PATH}/../get_temporary_dir.sh)
clear_db_ups_dir=${temporary_dir}/clear_db_ups
[[ -d ${clear_db_ups_dir} ]] && rm -rf ${clear_db_ups_dir}
mkdir -p ${clear_db_ups_dir}

exec_sql(){
    # get db info
    local db_name=${1}
    local instance_name=${2}
    if [[ ${db_name} = "DTPCDB" ]]
    then
        echo "${db_name}: delete from TBL_DBCHANGELOG_DBUPS where CREATE_TIME>now()-1;"
        sql="delete from TBL_DBCHANGELOG_DBUPS where CREATE_TIME>now()-1;"
    else
        echo "${db_name}: delete from TBL_DBCHANGELOG_DBUPS;"
        sql="delete from TBL_DBCHANGELOG_DBUPS;"
    fi

    cd ${CUR_PATH}/../pyscripts/utils/
    . /opt/oss/manager/bin/engr_profile.sh
    return_code=$(${PYTHONHOME}/bin/python -c "import common_method;print(common_method.CommonMethod().exec_sql('zenith', '${instance_name}', '${db_name}', sql='''${sql}''', retry_times=8, sleep_time=60, ignore_error_list=['does not exist']))")
    if [[ $? == "0" ]] && [[ "${return_code}" == "0" ]]
    then
        echo $(date '+%Y-%m-%d %H:%M:%S') [INFO] "exec sql successfully"
    else
        echo $(date '+%Y-%m-%d %H:%M:%S') [INFO] "exec sql failed"
        touch ${clear_db_ups_dir}/${instance_name}_${db_name}.txt
    fi
}

clear_db_ups_table(){
    # 保存container_list_file
    [[ -f ${save_container_list_file} ]] && rm -rf ${save_container_list_file}
    cd ${CUR_PATH}/../pyscripts/utils/
    . /opt/oss/manager/bin/engr_profile.sh
    ${PYTHONHOME}/bin/python -c "import common_method;common_method.CommonMethod().get_container_list(save_container_list_file='${save_container_list_file}')"
    if [[ $? -ne 0 ]]
    then
        echo "`date '+%Y-%m-%d %H:%M:%S'` get_container_list failed."
        exit 1
    else
        echo "`date '+%Y-%m-%d %H:%M:%S'` get_container_list success."
    fi

    instance_names=dcnnwcommondb,dcnnwlocaldb
    for instance_name in ${instance_names//,/ }
    do
        echo ${instance_name}
        need_db_names=`cat ${CUR_PATH}/db_ups_${instance_name}.txt`
        echo ${need_db_names}
        #运行函数：获取数据库ip,port, admin password
        # 获取db_names
        db_names=$(${PYTHONHOME}/bin/python -c "import common_method;print(common_method.get_all_db_name('${instance_name}', 'zenith', read_container_list_file='${save_container_list_file}'))") || exit 1
        echo ${db_names}
        for db_name in ${db_names//,/ }
        do
            db_name=$(echo ${db_name} | awk '{print toupper($0)}')
            if [[ "$need_db_names" == *"$db_name"* ]]
            then
                exec_sql ${db_name} ${instance_name} &
            else
                echo "${db_name} not in need_db_names"
            fi
        done
    done
    wait

    num=$(ls ${clear_db_ups_dir} | wc -l)
    if [[ ${num} -gt 0 ]]
    then
        echo $(date '+%Y-%m-%d %H:%M:%S') [INFO] "clear dbups failed"
        ls -l ${clear_db_ups_dir}
        exit 1
    fi

    [[ -f ${save_container_list_file} ]] && rm -rf ${save_container_list_file}
}

clear_db_ups_table

