'''
compare
'''

import os
import sys
import csv
import json

DB_REPORT = sys.argv[3]


def main():
    '''
    main
    :return:
    '''
    base_line = sys.argv[1]
    upgrade = sys.argv[2]
    none_instance = []
    none_dbs = []
    none_tables = []
    none_columns = []
    with open(base_line, "rb") as f_base, open(upgrade, "rb") as f_upgrade:
        json_base = json.load(f_base)
        json_upgrade = json.load(f_upgrade)
    # 循环基线中的所有的实例、db、表、字段，与升级上来的进行比较
    for db_instance in json_base.keys():
        if db_instance not in json_upgrade:
            none_instance.append([db_instance])
            continue
        for db_name in json_base[db_instance].keys():
            if db_name not in json_upgrade[db_instance]:
                none_dbs.append([db_instance, db_name])
                continue
            for table_name in json_base[db_instance][db_name].keys():
                if table_name not in json_upgrade[db_instance][db_name]:
                    none_tables.append([db_instance, db_name, table_name])
                    continue
                columns_base = set(json_base[db_instance][db_name][table_name].keys())
                columns_upgrade = set(json_upgrade[db_instance][db_name][table_name].keys())
                # 基线有的，但是升级上来没有的，说明升级后缺失了字段
                defect_columns = columns_base.difference(columns_upgrade)
                increase_columns = columns_upgrade.difference(columns_base)
                if defect_columns or increase_columns:
                    none_columns.append([db_instance, db_name, table_name,
                                         ",".join(defect_columns), ",".join(increase_columns),
                                         ",".join(columns_base), ",".join(columns_upgrade)])
    has_difference = False
    if none_instance:
        has_difference = True
        titles = ["defected_instance"]
        write_csv(titles, "instance_differencedifference_report.csv", none_instance)
    if none_dbs:
        has_difference = True
        titles = ["instance", "defected_db_name"]
        write_csv(titles, "db_difference_report.csv", none_dbs)
    if none_tables:
        has_difference = True
        titles = ["instance", "db_name", "defected_table_name"]
        write_csv(titles, "table_difference_report.csv", none_tables)
    if none_columns:
        has_difference = True
        titles = ["instance", "db_name", "table_name", "defected_columns", 
                  "increased_columns", "base_line_columns", "upgrade_columns"]
        write_csv(titles, "columns_difference_report.csv", none_columns)
    if not has_difference:
        titles = ["There is no difference in the database structure between the upgrade environment and the installation environment"]
        data = []
        write_csv(titles, "no_difference.txt", data)
        

def write_csv(titles, csv_name, data):
    '''
    :param titles: 
    :param csv_name: 
    :param data: 
    :return: 
    '''
    file_dir_path = os.path.join(DB_REPORT, "result")
    if not os.path.exists(file_dir_path):
        os.makedirs(file_dir_path)
    with open(os.path.join(file_dir_path, csv_name), "w", newline='', encoding="utf-8") as _f:
        csv_writer = csv.writer(_f)
        csv_writer.writerow(titles)
        csv_writer.writerows(data)


if __name__ == '__main__':
    main()
