#!/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
log_dir=`sh ${CUR_PATH}/../get_log_dir.sh`

tenant_name=NCECOMMONE
if [[ -d /opt/oss/NCE/apps ]]
then
    tenant_name=NCE
fi

if [[ ! -d /opt/oss/${tenant_name}/apps/SecoManagerService ]]
    then
        echo "secomanager is not installed."
        instance_names=dcnnecommondb,ncecommondb,ncelocaldb
    else
        echo "secomanager is installed."
        instance_names=dcnnecommondb,ncecommondb,ncesecmdb,ncelocaldb
fi

script_name=`basename $0`
print_log()
{
    local content=$*
    log_filename="$CUR_PATH/update_nw.log"
    echo $log_filename 
    CURTIME=`date '+%Y-%m-%d %H:%M:%S'`
    echo "Log: $CURTIME $$ $script_name : $content" | tee -a $log_filename
}

#获取数据库信息（query database)
get_dbip_port() {
    dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Master`

    if [ -z "$dbinfo" ]
    then
        print_log "$LINENO single db instance"
        dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"`
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_instance=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=''
        db_type=`echo $dbinfo|awk '{print $9}'`
    else
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_instance=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Slave|awk '{print $3}'`
        db_type=`echo $dbinfo|awk '{print $9}'`
    fi

    
}


main(){

    table_structrue="/opt/oss/table_structrue/pre_upgrade"
    if [[ -d "/opt/oss/table_structrue" ]]
    then
        rm -rf "/opt/oss/table_structrue"
    fi

    export_data="/opt/oss/export_data"
    rm -rf ${export_data}
    mkdir -p ${export_data}
    chmod -R 777 ${export_data}

    export_data_log="/opt/oss/export_data_log"
    rm -rf ${export_data_log}
    mkdir -p ${export_data_log}
    chmod -R 777 ${export_data_log}

    for instance_name in ${instance_names//,/ }
    do
        echo ${instance_name}
        #运行函数：获取数据库ip,port, admin password
        get_dbip_port $instance_name
        # 获取db_names
        db_names=`. /opt/oss/manager/agent/bin/engr_profile.sh; python $CUR_PATH/get_db_names.py ${instance_name} ${MACHINE_IP} ${port} zenith`
        echo ${db_names}

        # get_db_info(取当前实例的第一个db_name)
        db_names_now_array=(${db_names//,/ })
        db_names_one_of_now=${db_names_now_array[0]}
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "db_names_one_of_now: ${db_names_one_of_now}"
        db_info=`. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${CUR_PATH}/../pyscripts/');import get_db_pass;pec=get_db_pass.epc;fmt='';pec1=pec.getLogger('db_info');pec_s=pec.StreamHandler();pec_s.setFormatter(fmt);pec1.addHandler(pec_s);pec1.critical(get_db_pass.main('${instance_name}', '${db_names_one_of_now}', 'zenith'))" 2>&1`
        result=$?
        if [[ "${result}" == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get db_info successfully."
            result_array=(${db_info//,/ })
            adminPP=${result_array[2]}
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get db_info failed."
            exit 1
        fi

        for db_name in ${db_names//,/ }
        do
            . /opt/oss/manager/agent/bin/engr_profile.sh; python $CUR_PATH/get_table_structure.py ${db_name} ${adminPP} ${MACHINE_IP} ${port} ${instance_name} ${table_structrue} pre_upgrade ${instance_name} ${table_structrue}
            echo
            retry_times=5
            for((i=1;i<=${retry_times};i++))
            do
                sudo -s -u dbuser<<EOF
                mkdir -p ${export_data}/${instance_name}
                mkdir -p ${export_data_log}/${instance_name}
                source /home/dbuser/.bashrc
                source ~/.bashrc
                /opt/zenith/app/bin/zsql ${db_name}/${adminPP}@${MACHINE_IP}:${port} -c "EXP USERS = ${db_name} FILE='${export_data}/${instance_name}/${db_name}.dmp' FILETYPE=BIN PARALLEL=8 consistent=Y;" | tee ${export_data_log}/${instance_name}/${db_name}.log 2>&1
                chmod -R 777 ${export_data_log}/*
EOF
                is_success=$(cat ${export_data_log}/${instance_name}/${db_name}.log | grep -i "Logical export succeeded")
                if [[ -z "$is_success" ]]
                then
                    echo "${instance_name}.${db_name}: Logical export failed, retry_times: ${i}"
                    if [[ ${i} -eq ${retry_times} ]]
                    then
                        exit 1
                    fi
                    sleep 10
                else
                    echo "${instance_name}.${db_name}: Logical export succeeded."
                    break
                fi
            done
        done
    done
    cd $export_data
    sudo -u dbuser chmod 777 -R *
}
main

