#!/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
containerlist_old="/opt/upgrade/containerlist_old.json"
containerlist_old2="/opt/upgrade/containerlist_old2.json"

tenant_name=NCECOMMONE
if [[ -d /opt/oss/NCE/apps ]]
then
    tenant_name=NCE
fi

if [[ ! -d /opt/oss/${tenant_name}/apps/SecoManagerService ]]
    then
        echo "secomanager is not installed."
        instance_names=dcnnecommondb,ncecommondb,ncelocaldb
    else
        echo "secomanager is installed."
        instance_names=dcnnecommondb,ncecommondb,ncesecmdb,ncelocaldb
fi


script_name=`basename $0`
print_log()
{
    local content=$*
    log_filename="$CUR_PATH/update_nw.log"
    echo $log_filename 
    CURTIME=`date '+%Y-%m-%d %H:%M:%S'`
    echo "Log: $CURTIME $$ $script_name : $content" | tee -a $log_filename
}

#获取数据库信息（query database)
get_dbip_port() {
    dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Master`

    if [ -z "$dbinfo" ]
    then
        print_log "$LINENO single db instance"
        dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"`
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_instance=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=''
        db_type=`echo $dbinfo|awk '{print $9}'`
        master_instance_id=`echo $dbinfo|awk '{print $1}'`
    else
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_instance=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Slave|awk '{print $3}'`
        db_type=`echo $dbinfo|awk '{print $9}'`
        master_instance_id=`echo $dbinfo|awk '{print $1}'`
    fi

    
}



main(){

    import_data_log="/opt/oss/import_data_log"
    rm -rf ${import_data_log}
    mkdir -p ${import_data_log}
    chmod -R 777 ${import_data_log}

    # create_container_list
    . /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${CUR_PATH}/../pyscripts/');import create_container_list;create_container_list.main('${containerlist_old}', '${containerlist_old2}', '${instance_names}', 'zenith')"
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "create_container_list successfully."
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "create_container_list failed."
        exit 1
    fi

    sql_dir="/opt/oss/table_structrue/post_upgrade"
    if [[ -d ${sql_dir} ]]
    then
        rm -rf ${sql_dir}
    fi

    post_upgrade_structrue="/opt/oss/table_structrue/post_upgrade_structrue"
    if [[ -d ${post_upgrade_structrue} ]]
    then
        cp -rf ${post_upgrade_structrue} ${post_upgrade_structrue}_bak
    fi

    table_structrue="/opt/oss/table_structrue/pre_upgrade"
    export_data="/opt/oss/export_data"
    for instance_name_old in ${instance_names//,/ }
    do
        if [[ ${instance_name_old} == "ncelocaldb" ]]
        then
            instance_name="dcnnwlocaldb"
        else
            instance_name="dcnnwcommondb"
        fi
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "instance_name_old: ${instance_name_old}, instance_name_now: ${instance_name}"

        #运行函数：获取数据库ip,port, admin password
        get_dbip_port ${instance_name}
        # 获取db_names（当前nw实例下和备份路径下的）
        db_names_now=`. /opt/oss/manager/agent/bin/engr_profile.sh; python $CUR_PATH/get_db_names.py ${instance_name} ${MACHINE_IP} ${port} zenith`
        db_names_old=`ls ${export_data}/${instance_name_old}`
        echo ${db_names_now}
        echo ${db_names_old}


        # 创建数据库
        create_db_result=$(. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${CUR_PATH}/../pyscripts/');import db_action;print(db_action.main('add', '${instance_name}', 'zenith', '${CUR_PATH}/db_difference', '${master_instance_id}', '${db_names_now}', '${export_data}/${instance_name_old}', '${containerlist_old2}'))")
        if [[ ${create_db_result} == "0" && $? == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "create_db successfully."
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "create_db failed."
            exit 1
        fi

        # 创建后重新获取db_names_now
        db_names_now=`. /opt/oss/manager/agent/bin/engr_profile.sh; python $CUR_PATH/get_db_names.py ${instance_name} ${MACHINE_IP} ${port} zenith`
        echo "db names now after create db: ${db_names_now}"

        # get_db_info(取当前实例的第一个db_name)
        db_names_now_array=(${db_names_now//,/ })
        db_names_one_of_now=${db_names_now_array[0]}
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "db_names_one_of_now: ${db_names_one_of_now}"
        db_info=`. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${CUR_PATH}/../pyscripts/');import get_db_pass;pec=get_db_pass.epc;fmt='';pec1=pec.getLogger('db_info');pec_s=pec.StreamHandler();pec_s.setFormatter(fmt);pec1.addHandler(pec_s);pec1.critical(get_db_pass.main('${instance_name}', '${db_names_one_of_now}', 'zenith'))" 2>&1`
        result=$?
        if [[ "${result}" == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get db_info successfully."
            result_array=(${db_info//,/ })
            adminPP=${result_array[2]}
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get db_info failed."
            exit 1
        fi

        for db_dumps in `ls ${export_data}/${instance_name_old}`
        do
            if [[ -f ${export_data}/${instance_name_old}/${db_dumps} ]]
            then
                db_name_old_array=(${db_dumps//./ })
                db_name_old=${db_name_old_array[0]}

                # nw的实例下有可能没有相应的db(所以判断当前nw下是否包含升级前备份的db)
                is_now_contains_old=$(. /opt/oss/manager/agent/bin/engr_profile.sh;${PYTHONHOME}/bin/python -c "print(0) if '${db_name_old}' in '${db_names_now}'.split(',') else print(1)")
                if [[ "${is_now_contains_old}" == "0" ]]
                then
                    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "dbname db_name_old: ${db_name_old} in ${instance_name}"

                    # 导入数据
                    retry_times=5
                    for((i=1;i<=${retry_times};i++))
                    do
                        sudo -s -u dbuser<<EOF
                        mkdir -p ${import_data_log}/${instance_name}
                        source /home/dbuser/.bashrc
                        /opt/zenith/app/bin/zsql ${db_name_old}/${adminPP}@${MACHINE_IP}:${port} -c "IMP USERS = ${db_name_old} FILE='${export_data}/${instance_name_old}/${db_name_old}.dmp' FILETYPE=BIN PARALLEL=8 DDL_PARALLEL=4;" | tee ${import_data_log}/${instance_name}/${db_name_old}.log 2>&1
                        chmod -R 777 ${import_data_log}/*
EOF
                        is_success=$(cat ${import_data_log}/${instance_name}/${db_name_old}.log | grep -i "Logical import succeeded")
                        if [[ -z "$is_success" ]]
                        then
                            echo "${instance_name}.${db_name_old}: Logical import failed, retry_times: ${i}"
                            if [[ ${i} -eq ${retry_times} ]]
                            then
                                exit 1
                            fi
                            sleep 10
                        else
                            echo "${instance_name}.${db_name_old}: Logical import succeeded."
                            break
                        fi
                    done
                else
                    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "dbname db_name_old ${db_name_old} not in ${instance_name}, create ${db_name_old}"
                    # get_db_size
                    db_size=$(. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${CUR_PATH}/../pyscripts/');import get_db_size;print(get_db_size.main('${containerlist_old2}', '${instance_name}', '${db_name_old}', 'zenith'))")
                    if [[ -n "$db_size"  ]]
                    then
                        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get_db_size successfully: ${db_size} "
                    else
                        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get_db_size failed."
                        exit 1
                    fi

                    # 创建db
                    echo "/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd add-database -instid ${master_instance_id} -dbnames ${db_name_old} -appnames MyService -datasizes ${db_size}"
                    /opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd add-database -instid ${master_instance_id} -dbnames ${db_name_old} -appnames MyService -datasizes ${db_size}
                    result=$?
                    if [[ "${result}" == "0" ]]
                    then
                        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "create db successfully"
                    else
                        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "create db failed."
                        exit 1
                    fi

                    # 导入数据
                    retry_times=5
                    for((i=1;i<=${retry_times};i++))
                    do
                        sudo -s -u dbuser<<EOF
                        mkdir -p ${import_data_log}/${instance_name}
                        source /home/dbuser/.bashrc
                        /opt/zenith/app/bin/zsql ${db_name_old}/${adminPP}@${MACHINE_IP}:${port} -c "IMP USERS = ${db_name_old} FILE='${export_data}/${instance_name_old}/${db_name_old}.dmp' FILETYPE=BIN PARALLEL=8 DDL_PARALLEL=4;" | tee ${import_data_log}/${instance_name}/${db_name_old}.log 2>&1
                        chmod -R 777 ${import_data_log}/*
EOF
                        is_success=$(cat ${import_data_log}/${instance_name}/${db_name_old}.log | grep -i "Logical import succeeded")
                        if [[ -z "$is_success" ]]
                        then
                            echo "${instance_name}.${db_name_old}: Logical import failed, retry_times: ${i}"
                            if [[ ${i} -eq ${retry_times} ]]
                            then
                                exit 1
                            fi
                            sleep 10
                        else
                            echo "${instance_name}.${db_name_old}: Logical import succeeded."
                            break
                        fi
                    done

                fi
            fi
        done

    done
}
main

