'''
zenith操作
'''
import pyzenith  # pylint:disable=import-error

class Zenith:
    '''
    zenith操作
    '''
    def __init__(self, host, username, password, port):
        self.conn = pyzenith.connect(host, username, password, port)
        self.cursor = self.conn.cursor()

    def commit(self):
        '''
        commit
        :return:
        '''
        self.conn.commit()

    def insert_many(self, table_name, value):
        '''
        插入多条
        :param table_name:
        :param value:
        :return:
        '''
        length = len(value[0])
        sql = "insert into %s values (" % table_name
        sql = self.concat_sql(sql, length)
        self.cursor.executemany(sql, value)

    def concat_sql(self, sql, length):
        '''
        拼接sql
        :param sql:
        :param length:
        :return:
        '''
        for num in range(1, length + 1):
            if num == length:
                sql += ":%s)" % num
            else:
                sql += ":%s, " % num
        return sql

    def excute(self, sql):
        '''
        执行
        :param sql:
        :return:
        '''
        self.cursor.execute(sql)

    def select(self, sql):
        '''
        查询
        :param sql:
        :return:
        '''
        self.cursor.execute(sql)
        return self.cursor.fetchall()

    def close(self):
        '''
        关闭连接
        :return:
        '''
        self.commit()
        self.cursor.close()
        self.conn.close()
