#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
step=${4}
upgrade_json_file_dir="/opt/oss/${tenant_name}/apps/SecoManagerService/upgrade_fabric"
upgrade_json_file="/opt/oss/${tenant_name}/apps/SecoManagerService/upgrade_fabric/upgrade.json"
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


if [[ ! -d /opt/oss/${tenant_name}/apps/SecoManagerService ]]
then
    echo "secomanager is not installed, skip it." >> ${log_file}
    exit 0
fi


if [ ! -d "${upgrade_json_file_dir}" ]; then
    echo "secomanager is no needed migrating, skip it." >> ${log_file}
    exit 0
fi

function main()
{
    #解析Secomanager的json并执行
    sudo -u ossuser chmod -R 777 ${upgrade_json_file_dir}
    cd ${EXEC_HOME}/../
    py_result=$(. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import read_config;print(read_config.main('${upgrade_path}', '${tenant_name}', '${log_file}', '${step}', upgrade_json_file='${upgrade_json_file}', record_name='SecoManager'))")
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "the result is:"  >> ${log_file}
    echo "$py_result"  >> ${log_file}
    sudo -u ossuser chmod -R 750 ${upgrade_json_file_dir}
    # 处理结果
    result_code=$(. /opt/oss/manager/agent/bin/engr_profile.sh;python ${EXEC_HOME}/../pyscripts/get_result_code.py "$py_result")
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "the result_code is: ${result_code}"  >> ${log_file}
    if [[ ${result_code} == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "${self_name} has been executed successfully."  >> ${log_file}
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "${self_name} has been executed failed."  >> ${log_file}
        exit 1
    fi
}
main $@ >> ${log_file} 2>&1

