#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}


function main()
{
    if [[ ! -d /opt/oss/${tenant_name}/apps/BgpService ]]
    then
        echo "BgpService is not installed, skip it."
        exit 0
    fi

    # 获取节点IP（线上版）
    . /opt/oss/manager/agent/bin/engr_profile.sh
    IPS=$(python ${EXEC_HOME}/../pyscripts/updatenodes_NCE.py)
    result=$?
    if [[ ${result} == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get IPS successfully: ${IPS}"
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get IPS failed"
            exit 1
    fi

    IPS_array=(${IPS//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        echo "stop ElectionAgentService in $ip"
        ssh ossadm@"$ip" << remotessh
            /opt/oss/manager/agent/bin/ipmc_adm -cmd stopapp -app "ElectionAgentService"
            exit
remotessh
    done
    sleep 5
    
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        echo "stop BgpService in $ip"
        ssh ossadm@"$ip" << remotessh
            /opt/oss/manager/agent/bin/ipmc_adm -cmd stopapp -app "BgpService"
            sudo -u ossuser sh /opt/oss/${tenant_name}/apps/BgpService/cloudsnc/bgp/vrpv8/bin/etcd_ha.sh 0 Stop
            exit
remotessh
    done
    sleep 5
}

main $@ >> ${log_file} 2>&1