#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
data_migrate_dir=`sh ${EXEC_HOME}/../get_data_migrate_dir.sh ${upgrade_path}`
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "data_migrate_dir is ${data_migrate_dir}" | tee -a ${log_file}


#AAA 迁移
function execute_service_scripts()
{
    execute_path=$1
    check_flag=$2
    base_path=${EXEC_HOME}/../plugins
    find $base_path/$execute_path/post_upgrade_*.sh  2>/dev/null

    if [ $? -eq 0 ];then
        rm -rf $base_path/$execute_path/*.result
        result_arry=()
        for custScript in  $base_path/$execute_path/post_upgrade_*.sh
        do
            echo "[`date`] call product $execute_path ..."
            sh ${custScript} &
            result_arry[${#result_arry[*]}]=${custScript%.sh}.result
        done

        if [ "$check_flag" != "without_check" ];then
            for ((i=0; i<180; i++))
            do
                for result in ${result_arry[@]}
                do
                    cat $result 2>/dev/null |grep 1 >/dev/null
                    if [ $? -eq 0 ];then
                        echo "[`date`] $execute_path script: ${result%.result} execute failed."
                        exit 1
                    fi
                    cat $result 2>/dev/null |grep 0 >/dev/null
                    if [ $? -eq 0 ];then
                        result_arry=(`echo ${result_arry[@]/$result/}`)
                    fi
                done
                if [ ${#result_arry[@]} -eq 0 ];then
                    echo "[`date`] all $execute_path script execute successful."
                    break
                fi
                echo "[`date`] waiting fot all $execute_path script execute successful..."
                sleep 5
            done

            if [ ${#result_arry[@]} -ne 0 ];then
                echo "[`date`] $execute_path script: ${result_arry[@]%.result} execute timeout."
                exit 1
            fi
        fi

    fi
}

function main(){
    #3A解耦迁移-业务（启动服务前）
    execute_service_scripts "AAA_post_upgrade_before"
}

main $@ >> ${log_file} 2>&1