#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}

echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
data_migrate_dir=`sh ${EXEC_HOME}/../get_data_migrate_dir.sh ${upgrade_path}`
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "data_migrate_dir is ${data_migrate_dir}" | tee -a ${log_file}

function main(){
    # 3A解耦迁移-平台（启动服务前）
    rm -rf ${data_migrate_dir}/migrate_cloudsop
    rm -rf /opt/oss/tmp_data
    unzip -q ${data_migrate_dir}/ImapUpgradeService*.zip -d ${data_migrate_dir}/migrate_cloudsop
    mkdir -p ${data_migrate_dir}/migrate_cloudsop/cloudsop_tool/conf/connections
    # 不同的升级路径配置不提供的AAA迁移白名单
    if [[ ! -z $(echo $upgrade_path| grep "V100R020C00") ]]; then
        # R20C00
        export MIGRATE_SERVICE_LIST="OMPubService,AuthService,DomainService,CronService,NorthboundCommunicationService,FMService,SnbCertMgmtService,SnmpAgentService"
        cp -f /opt/upgrade/containerlist_old2.json ${data_migrate_dir}/migrate_cloudsop/cloudsop_tool/conf/connections/containerlist_old.json
    elif [[ ! -z $(echo $upgrade_path| grep "R019C00") ]]; then
        # R19C00
        export MIGRATE_SERVICE_LIST="OMPubService,AuthService,DomainService,CronService,HFSTrackerService,NorthboundCommunicationService,FMService,FMDBService,SnbCertMgmtService,ExtendedPkgmgrService"
        cp -f /opt/upgrade/containerlist_old.json ${data_migrate_dir}/migrate_cloudsop/cloudsop_tool/conf/connections/containerlist_old.json
    elif [[ ! -z $(echo $upgrade_path| grep "R019C10") ]]; then
        # R19C10
        export MIGRATE_SERVICE_LIST="OMPubService,AuthService,DomainService,CronService,DriverMgmtService,HFSTrackerService,NorthboundCommunicationService,FMService,ExtendedPkgmgrService,SnbCertMgmtService,SnmpAgentService"
        cp -f /opt/upgrade/containerlist_old.json ${data_migrate_dir}/migrate_cloudsop/cloudsop_tool/conf/connections/containerlist_old.json
    fi
    cp -f /opt/upgrade/containerlist_new.json ${data_migrate_dir}/migrate_cloudsop/cloudsop_tool/conf/connections/containerlist_new.json
    mkdir -p /opt/oss/tmp_data
    chmod 770 /opt/oss/tmp_data
    export MIGRATE_DATA_DIR=/opt/oss/tmp_data

    bash ${data_migrate_dir}/migrate_cloudsop/cloudsop_tool/bin/cloudsop_upgrade.sh process
    if [[ $? -ne 0 ]]
    then
        echo "[`date`] migrate cloudsop failed."
        exit 1
    else
        echo "[`date`] migrate cloudsop success."
    fi
}

main $@ >> ${log_file} 2>&1