#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
log_dir=$(sh ${EXEC_HOME}/../get_log_dir.sh)
data_migrate_dir=`sh ${EXEC_HOME}/../get_data_migrate_dir.sh ${upgrade_path}`
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}


function main()
{
    #操作系统升级后北向浮动ip一直在主备管理节点之间跳动且APIMLBService服务异常起不来规避办法（nginx配置多空格问题）
    burst1=`sudo -u ossuser grep -n "burst=250" /opt/oss/share/NCECOMMONE/APIMLBService/nginx/etc/nginx/conf/nginx_er.conf`
    burst2=`sudo -u ossuser grep -n "burst=250" /opt/oss/share/NCE/APIMLBService/nginx/etc/nginx/conf/nginx_er.conf`
    if [ -n "$burst1" ];then
            /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "APIMLBService" | grep "apimlb" | awk '{print $6}' | while read line
            do
                    ssh ossadm@"$line" << remotessh
                    sudo -u ossuser sed -i '/burst=250/c\limit_req zone=req_one burst=250;' /opt/oss/share/NCECOMMONE/APIMLBService/nginx/etc/nginx/conf/nginx_er.conf
                    sudo -u ossuser sed -i '/burst=200/d' /opt/oss/share/NCECOMMONE/APIMLBService/nginx/etc/nginx/conf/nginx_er.conf
                    exit
remotessh
            done
    fi

    if [ -n "$burst2" ];then
            /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "APIMLBService" | grep "apimlb" | awk '{print $6}' | while read line
            do
                    ssh ossadm@"$line" << remotessh
                    sudo -u ossuser sed -i '/burst=250/c\limit_req zone=req_one burst=250;' /opt/oss/share/NCE/APIMLBService/nginx/etc/nginx/conf/nginx_er.conf
                    sudo -u ossuser sed -i '/burst=200/d' /opt/oss/share/NCE/APIMLBService/nginx/etc/nginx/conf/nginx_er.conf
                    exit
remotessh
            done
    fi
}

main $@ >> ${log_file} 2>&1