#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}


function main()
{
    # 获取环境上containlist_new.json
    . /opt/oss/manager/bin/engr_profile.sh
    ${PYTHONHOME}/bin/python ${EXEC_HOME}/../pyscripts/deal_container_list.py
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "deal_container_list successfully."
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "deal_container_list failed."
        exit 1
    fi
}

main $@ >> ${log_file} 2>&1