#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
data_migrate_dir=`sh ${EXEC_HOME}/../get_data_migrate_dir.sh ${upgrade_path}`
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "data_migrate_dir is ${data_migrate_dir}" | tee -a ${log_file}

#删除dpsDbInstance01实例
function main(){
    if [[ -f $EXEC_HOME/dpsDbInstanceID.txt ]]
    then
        rm $EXEC_HOME/dpsDbInstanceID.txt
    fi
    /opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -tenant $tenant_name|grep dpsDbInstance01 |grep Master|awk '{print $1 "\t" $6}' >> $EXEC_HOME/dpsDbInstanceID.txt

    cat $EXEC_HOME/dpsDbInstanceID.txt|while read line
    do
        instname=`echo $line|awk '{print $1}'`
        echo $instname
        ip=`echo $line|awk '{print $2}'`
        echo $ip
        ssh -o StrictHostKeyChecking=no ossadm@$ip << EOF
        /opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd delete-db-instance -instid $instname
        exit
EOF
    done
}

main $@ >> ${log_file} 2>&1