#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}


function main()
{
    # 重新执行 secomanger db_ups，抹平因导入数据造成的数据库差异
    cd ${EXEC_HOME}/../exp_imp_data/
    . /opt/oss/manager/agent/bin/engr_profile.sh;sudo -u ossuser sh exec_db_ups_secomanger.sh ${PYTHONHOME}

    # 重新执行 产品db_ups，抹平因导入数据造成的数据库差异
    cd ${EXEC_HOME}/../exp_imp_data/
    . /opt/oss/manager/agent/bin/engr_profile.sh;sh clear_db_ups_table.sh
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "clear_db_ups_table successfully."
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "clear_db_ups_table failed."
        exit 1
    fi
    service_list=`cat db_ups_services.txt`
    . /opt/oss/manager/agent/bin/engr_profile.sh;sudo -u ossuser sh exec_db_ups_NCE.sh ${service_list} ${PYTHONHOME}
}

main $@ >> ${log_file} 2>&1