#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}


function main()
{
    # 【问题背景】 R20.1 升级到 R21.0.111 镜像环境业务审视，发现紧急告警，服务无主
    # 【问题根因】 R20.1 引入云化CloudLicenseProxy; 这个是一个测试服务，概率性内存溢出，导致浮动IP来回飘。111补丁删除 CloudLicenseProxy; 但选主配置残留
    # 删除后，依靠升级机制，在数据迁移后，ElectionAgentService就会启动
    file_name=/opt/oss/share/${tenant_name}/ElectionAgentService/CloudLicenseProxy
    /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "ElectionAgentService" | grep "electionagentservice" | awk '{print $6}' | while read line
    do
        echo "deal ElectionAgentService in ${line}"
        ssh ossadm@"$line" << remotessh
             if [[ -d ${file_name} ]] || [[ -f ${file_name} ]]
             then
                 echo "${file_name} exists, remove it"
                 sudo -u ossuser rm -rf ${file_name}
             fi
            exit
remotessh
    done
}

main $@ >> ${log_file} 2>&1