#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}

start_or_stop_app(){
    /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "$1" | grep "$2" | awk '{print $6}' | while read line
    do
        echo "stop $1 in $line"
        ssh ossadm@"$line" << remotessh
            /opt/oss/manager/agent/bin/ipmc_adm -cmd $3 -app "$1"
            exit
remotessh
    done
}

function main()
{
    # 迁移前启动HIROIRService
    /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "HIROIRService" | grep "hiroir" | awk '{print $6}' | while read line
    do
        echo "restart HIROIRService in ${line}"
        ssh ossadm@"$line" << remotessh
            /opt/oss/manager/agent/bin/ipmc_adm -cmd startapp -app "HIROIRService"
            exit
remotessh
    done
    sleep 30
}

main $@ >> ${log_file} 2>&1