#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
out_put_file=${4}
log_dir=$(sh ${EXEC_HOME}/../get_log_dir.sh)
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main()
{
    # 生成特性
    cd ${EXEC_HOME}/../pyscripts
    is_ipv6=$(. /opt/oss/manager/bin/engr_profile.sh;$PYTHONHOME/bin/python ${EXEC_HOME}/../pyscripts/is_ipv6.py)
    . /opt/oss/manager/bin/engr_profile.sh;python -c "import create_features;create_features.CreateFutures('${EXEC_HOME}/product_${tenant_name}.json', '${is_ipv6}', '${EXEC_HOME}/../', '${log_dir}', '${out_put_file}', '${upgrade_path}').main()"
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "create feature successfully."
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "create feature failed."
        exit 1
    fi
}
main $@ >> ${log_file} 2>&1