#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main()
{
    cd ${EXEC_HOME}/../exp_imp_data/
    # R20C00和R20C10导入使用的都是这个脚本
    bash import_data_R20C00.sh
    if [[ $? -ne 0 ]]
    then
        echo "[`date`] import data failed."
        exit 1
    else
        echo "[`date`] import data success."
    fi
}
main $@ >> ${log_file} 2>&1