#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
IPS=${4}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}

log_dir=$(sh ${EXEC_HOME}/../get_log_dir.sh)
data_migrate_dir=`sh ${EXEC_HOME}/../get_data_migrate_dir.sh ${upgrade_path}`
dir_path=${EXEC_HOME}/query_protcuct_after_bgp
temporary_dir=$(sh ${EXEC_HOME}/../get_temporary_dir.sh)
add_bgp_nic_flag=${temporary_dir}/add_nic_flag.txt
[[ -f ${add_bgp_nic_flag} ]] && rm -rf ${add_bgp_nic_flag}
netcard_info_dir=${temporary_dir}/netcard_info
[[ -d ${netcard_info_dir} ]] && rm -rf ${netcard_info_dir}
mkdir -p ${netcard_info_dir}

function main()
{
    if [[ ! -d /opt/oss/${tenant_name}/apps/BgpService ]]
    then
        echo "BgpService is not installed, skip it."
        exit 0
    fi

    . /opt/oss/manager/agent/bin/engr_profile.sh
    IPS2=$(${PYTHONHOME}/bin/python -c "print(','.join('${IPS}'.replace(':9094', '').split(',')))")
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo "$(date '+%Y-%m-%d %H:%M:%S') [INFO] get IPS2 successfully: ${IPS2}"
    else
        echo "$(date '+%Y-%m-%d %H:%M:%S') [INFO] get IPS2 failed"
        exit 1
    fi

    # 创建目录
    if [[ -d ${dir_path} ]]
    then
        rm -rf ${dir_path}
    fi
    mkdir -p ${dir_path}
    # 生成产品信息
    /opt/oss/manager/tools/resmgr/queryproduct.sh -pn ${tenant_name} -output ${dir_path}
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo "$(date '+%Y-%m-%d %H:%M:%S') [INFO] queryproduct successfully"
    else
        echo "$(date '+%Y-%m-%d %H:%M:%S') [INFO] queryproduct failed"
        exit 1
    fi

    # 生成网卡信息
    bash /usr/local/osconfig/os/bin/getipinfo.sh -output ${dir_path}/netcard_info.json
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "getipinfo successfully"
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "getipinfo failed"
        exit 1
    fi

    # 如果文件中没有BGPSouth，将bgp所在网卡加入到管理面
    has_bgp_south=$(cat ${dir_path}/networkinfo_${tenant_name}.json | grep -i "BGPSouth")
    if [[ -z ${has_bgp_south} ]]
    then
        touch ${add_bgp_nic_flag}
        IPS_array=(${IPS2//,/ })
        for ip in ${IPS_array[@]}
        do
            file_name=${temporary_dir}/netcard_info_${ip}.json
            ssh ossadm@"$ip" << remotessh
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "execute in ${ip}"
                [[ ! -d ${temporary_dir} ]] && mkdir -p ${temporary_dir}
                [[ -f ${file_name} ]] && rm -rf ${file_name}
                bash /usr/local/osconfig/os/bin/getipinfo.sh -output ${file_name}
                exit
remotessh
        rsync ossadm@[$ip]:${file_name} ${netcard_info_dir}
        done

        # 将bgp所在网卡加入到管理面
        ${PYTHONHOME}/bin/python ${EXEC_HOME}/../pyscripts/add_bgp_float_ip.py "add_nic" ${dir_path} ${tenant_name} ${netcard_info_dir} ${IPS2}
        result=$?
        if [[ "${result}" == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "Add nic successfully"
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "Add nic failed"
            exit 1
        fi
    fi

    # 修改bgp网卡用途
    ${PYTHONHOME}/bin/python ${EXEC_HOME}/../pyscripts/add_bgp_float_ip.py "add_bgp" ${dir_path} ${tenant_name} ${netcard_info_dir} ${IPS2}
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "Add bgp float ip successfully"
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "Add bgp float ip failed"
        exit 1
    fi
}


main $@ >> ${log_file} 2>&1