#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main(){
    oam_ip=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global | grep -w "OAMService-2-0" | awk '{print $6}'`
    if [ "$oam_ip" = "" ]
    then
        echo "single env"
    else
        echo "modify stop time"
        ssh ossadm@"$oam_ip" << remotessh
        if [ -f "/opt/oss/NCECOMMONE/apps/DCNOAMService/pub/app_define.json" ]
        then
            sudo -u ossuser sed  -i "s/\"stopTimeout\": \"[0-9]*\"/\"stopTimeout\": \"1800\"/g" /opt/oss/NCECOMMONE/apps/DCNOAMService/pub/app_define.json
            sudo -u ossuser sed  -i "s/\"startTimeout\": \"[0-9]*\"/\"startTimeout\": \"1800\"/g" /opt/oss/NCECOMMONE/apps/DCNOAMService/pub/app_define.json
        else
            sudo -u ossuser sed  -i "s/\"stopTimeout\": \"[0-9]*\"/\"stopTimeout\": \"1800\"/g" /opt/oss/NCE/apps/DCNOAMService/pub/app_define.json
            sudo -u ossuser sed  -i "s/\"startTimeout\": \"[0-9]*\"/\"startTimeout\": \"1800\"/g" /opt/oss/NCE/apps/DCNOAMService/pub/app_define.json
        fi
        exit
remotessh
    fi
}

main $@ >> ${log_file} 2>&1