#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main(){
    # dmq回退资源清理
    /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "DmqKafkaService" | grep "dmqkafkasvr" | awk '{print $6}' | while read line
    do
        {
        delete_dmq $line
        }&
    done
    wait
}

function delete_dmq() {
    local ip=$1
    echo "Stop and clear DmqKafkaService in $ip"
    ssh ossadm@$ip << remotessh
        /opt/oss/manager/agent/bin/ipmc_adm -cmd stopapp -app "DmqKafkaService"
        sudo -u ossuser rm -rf /opt/oss/share/*/DmqKafkaService/kafka-logs/*-*
        exit
remotessh
}

main $@ >> ${log_file} 2>&1