#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
IPS=${4}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main(){

    # 等待15分钟，每次间隔30s，直到cluster_id不为空
    retry_times=30
    for((i=1;i<=${retry_times};i++))
    do
        cluster_id=$(. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${EXEC_HOME}/../pyscripts/');import get_cluster_id;print(get_cluster_id.main())")
        if [[ $? == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get cluster_id successfully."
            if [[ -z "$cluster_id" ]]
            then
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "the cluster_id is empty, retry_times: ${i}"
            else
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "the cluster_id is: $cluster_id"
                break
            fi
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get cluster_id failed, retry_times: ${i}"
        fi

        if [[ ${i} -eq ${retry_times} ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "the cluster_id is empty, skip"
            exit 0
        fi
        sleep 30
    done


    #增加数据库句柄数
    IPS_array=(${IPS//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        echo "modify meta.properties and restart MCZKService in $ip"
        ssh ossadm@"$ip" << remotessh
            if [[ -f /opt/oss/share/SMPMQService/kafka-logs/meta.properties ]]
            then
                sed -i "/cluster.id=/c\cluster.id=$cluster_id" /opt/oss/share/SMPMQService/kafka-logs/meta.properties
                /opt/oss/manager/agent/bin/ipmc_adm -cmd restartapp -app "SMPMQService" -tenant manager
            fi
           exit
remotessh
    done

}

main $@ >> ${log_file} 2>&1