#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
data_migrate_dir=`sh ${EXEC_HOME}/../get_data_migrate_dir.sh ${upgrade_path}`
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "data_migrate_dir is ${data_migrate_dir}" >> ${log_file}

function main(){
    #3A解耦迁移-业务（启动服务后）

    #3A解耦迁移-平台（启动服务后）
    export MIGRATE_DATA_DIR=/opt/oss/tmp_data
    # 路径需要优化-动态获取
    bash ${data_migrate_dir}/migrate_cloudsop/cloudsop_tool/bin/cloudsop_upgrade.sh post_process
    if [[ $? -ne 0 ]]
    then
        echo "[`date`] migrate cloudsop after start failed."
        exit 1
    else
        echo "[`date`] migrate cloudsop after start success."
    fi
}

main $@ >> ${log_file} 2>&1