#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){
    retry_times=8
    cd ${EXEC_HOME}/../plugins/faultservice_migrate
    result=`find . -name migrated.txt | wc -l`
    if [[ ${result} -eq 0 ]]
    then
        for((i=1;i<=${retry_times};i++))
        do
            . /opt/oss/manager/bin/engr_profile.sh; bash migrate_common.sh
            result=$?
            if [[ "${result}" == "0" ]]
            then
                echo "Faultservice migrates successfully."
                break
            else
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "Faultservice migrates failed, retry_times: ${i}"
                if [[ ${i} -eq ${retry_times} ]]
                then
                    exit 1
                fi
                sleep 5
            fi
        done
    else
        echo "Faultservice has migrated"
    fi
}

main $@ >> ${log_file} 2>&1