#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
temporary_dir=$(sh ${EXEC_HOME}/../get_temporary_dir.sh)
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main(){
    # 与安装对齐，管理面增加历史查询菜单
    dir="${temporary_dir}/upgrade_info_common_post"
    if [[ ! -d ${dir} ]]
    then
        rm -rf ${dir}
    fi
    mkdir -p ${dir}

    for i in {1..4}
    do
        success=0
        echo "`date +%Y%m%d%H%M%S` exec_times: ${i}"

        bash /opt/oss/manager/tools/resmgr/queryproduct.sh -pn ${tenant_name} -output ${dir}
        if [[ $? != 0 ]]
        then
            echo "`date +%Y%m%d%H%M%S` [ERROR] can not find any product, exec_times: ${i}"
            success=1
        else
            # 内存中的数据强制向硬盘中保存
            sync ${dir}/product_${tenant_name}.json
            has_monitor_full_ability=$(cat ${dir}/product_${tenant_name}.json | grep "monitor_full_ability")
            if [[ -z ${has_monitor_full_ability} ]]
            then
                sed -i "s/productext\":{/productext\":{\"monitor_full_ability\":\"1\",/g" ${dir}/product_${tenant_name}.json
                bash /opt/oss/manager/tools/resmgr/modifyproductinfo.sh -input ${dir}/product_${tenant_name}.json
                if [[ $? != 0 ]]
                then
                    echo "`date +%Y%m%d%H%M%S` [ERROR] add_manager_plane_history_menu failed, exec_times: ${i}"
                    success=1
                else
                    echo "`date +%Y%m%d%H%M%S` [INFO] add_manager_plane_history_menu success"
                fi
            else
                echo "`date +%Y%m%d%H%M%S` [INFO] do not need add_manager_plane_history_menu, skip"
            fi
        fi

        if [[ ${success} == "0" ]]
        then
            exit 0
        else
            if [[ ${i} -eq 4 ]]
            then
                exit 1
            fi
            sleep 10
        fi

    done


}

main $@ >> ${log_file} 2>&1