#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){
    # 容灾场景加固添加主备白名单
    master_ip="/opt/oss/easysuite/easysuite/easysuite/plugins/iMasterNCE-Fabric/upgrade_online/service/master_ip.txt"
    slave_ip="/opt/oss/easysuite/easysuite/easysuite/plugins/iMasterNCE-Fabric/upgrade_online/service/slave_ip.txt"
    if [[ -f $master_ip ]]
    then
        master_ip=`cat $master_ip`
        slave_ip=`cat $slave_ip`
        cd /opt/oss/manager/agent/bin
        bash sshd_ipsadm.sh -cmd set -extips ${master_ip}
        bash sshd_ipsadm.sh -cmd set -extips ${slave_ip}
        result=$?
        if [[ "${result}" == "0" ]]
        then
            exit 0
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "Success to add the trustlist."
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "Failed to add the trustlist."
            exit 1
        fi
    fi
}

main $@ >> ${log_file} 2>&1