#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
log_dir=$(sh ${EXEC_HOME}/../get_log_dir.sh)
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){
    # 检测包管理ok后再继续执行
    cd ${EXEC_HOME}/../pyscripts/
    result_status=$(. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${EXEC_HOME}/../pyscripts/');import check_package_status;print(check_package_status.main('${log_dir}'))")

    if [[ $? == "0" ]]
    then
        if [[ ${result_status} == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "the package status is ok."
        elif [[ ${result_status} == "1" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "the package status is not ok."
            exit 1
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "check package status failed."
            exit 1
        fi
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "check package status failed."
        exit 1
    fi
}

main $@ >> ${log_file} 2>&1