#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
IPS=${4}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main()
{
    DCNOpenEMService_bak_dir=/opt/oss/upgrade_dir_for_ossuser/DCNOpenEMService
    IPS_array=(${IPS//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        ssh ossadm@${ip} << EOF
             echo "delete dir in ${ip}"
             sudo -u ossuser rm -rf ${DCNOpenEMService_bak_dir}
            exit
EOF
    done
}
main >> ${log_file} 2>&1