#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


#删除设计态 dcnnwcommondb实例下dcnsfcsimpersistentdb、dcnsimpersistentdb
function delete_dcnnwcommondb(){
    instname=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep dcnnwcommondb |grep Master|awk '{print $1}'`
    instance_ip=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep dcnnwcommondb |grep Master|awk '{print $6}'`
    ssh -o StrictHostKeyChecking=no ossadm@${instance_ip} << EOF
        /opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd remove-database -instid ${instname} -dbnames dcnsimpersistentdb,dcnsfcsimpersistentdb
        exit
EOF
}

function main()
{
    cd ${EXEC_HOME}
    #删除设计态 dcnnwcommondb实例下dcnsfcsimpersistentdb、dcnsimpersistentdb
    DESIGN_IP=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global | grep DCNSimulatorService`
    if [[ ! -z ${DESIGN_IP} ]]
    then
        echo "DCNSimulatorService environment $DESIGN_IP"
        delete_dcnnwcommondb
        echo "delete finish"
    fi
}

main $@ >> ${log_file} 2>&1