#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
log_dir=`sh ${EXEC_HOME}/../get_log_dir.sh`
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
data_migrate_dir=`sh ${EXEC_HOME}/../get_data_migrate_dir.sh ${upgrade_path}`
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "data_migrate_dir is ${data_migrate_dir}" >> ${log_file}

#获取数据库信息（query database)
get_dbip_port() {
    dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Master`

    if [ -z "$dbinfo" ]
    then
        echo " single db instance"
        dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"`
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_instance=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=''
        db_type=`echo $dbinfo|awk '{print $9}'`
        master_instance_id=`echo $dbinfo|awk '{print $1}'`
    else
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_instance=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Slave|awk '{print $3}'`
        db_type=`echo $dbinfo|awk '{print $9}'`
        master_instance_id=`echo $dbinfo|awk '{print $1}'`
    fi


}

function delete(){
    local instance_name=${1}
    local file_path=${2}
    get_dbip_port ${instance_name}
    delete_db_result=$(. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${EXEC_HOME}/../pyscripts/');import db_action;print(db_action.main('delete', '${instance_name}', 'zenith', '${file_path}', '${master_instance_id}'))")
    if [[ ${delete_db_result} == "0" && $? == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "${instance_name} delete_db successfully."
        if [[ -f ${file_path}_${instance_name}.txt ]]
        then
            mv ${file_path}_${instance_name}.txt ${log_dir}
        fi
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "${instance_name} delete_db failed."
        exit 1
    fi
}

function main(){
    file_path=${EXEC_HOME}/../exp_imp_data/db_difference
    instance_name=dcnnwcommondb
    delete dcnnwcommondb ${file_path}
    delete dcnnwlocaldb ${file_path}
}

main $@ >> ${log_file} 2>&1