#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


#删除dcnnwcommondb实例下无效的smpmanagerservicedb、apollobrainservicedb
function delete_dcnnwcommondb(){
    instname=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep dcnnwcommondb |grep Master|awk '{print $1}'`
    instance_ip=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep dcnnwcommondb |grep Master|awk '{print $6}'`
    ssh -o StrictHostKeyChecking=no ossadm@${instance_ip} << EOF
        /opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd remove-database -instid ${instname} -dbnames smpmanagerservicedb,apollobrainservicedb
        exit
EOF
}

function main()
{
    echo "Start deleting smpmanagerservicedb and apollobrainservicedb in dcnnwcommondb."
    delete_dcnnwcommondb
    echo "Delete smpmanagerservicedb and apollobrainservicedb in dcnnwcommondb over."
}

main $@ >> ${log_file} 2>&1