#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){
    # 获取源版本和目标版本
    versions=$(sh ${EXEC_HOME}/get_version.sh ${upgrade_path})
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo "get src_version or des_version successfully."
    else
        echo "get src_version or des_version failed."
        exit 1
    fi
    versions_array=(${versions//,/ })
    src_version=${versions_array[0]}
    des_version=${versions_array[1]}
    echo "src_version: ${src_version}, des_version: ${des_version}"

    # 设备角色同步DT库
    ${PYTHONHOME}/bin/python ${EXEC_HOME}/../pyscripts/fabric_dt_upgrade.py ${src_version} ${des_version}
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo "device role to DT successfully."
    else
        echo "device role to DT failed."
        exit 1
    fi
}

main $@ >> ${log_file} 2>&1