#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


start_or_stop_app(){
    /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "$1" | grep "$2" | awk '{print $6}' | while read line
    do
        echo "$3 $1 in $line"
        ssh ossadm@"$line" << remotessh
            /opt/oss/manager/agent/bin/ipmc_adm -cmd $3 -app "$1"
            exit
remotessh
    done
}


function main(){

    # InvMirrorService 必须 和 InvHistoryService同时安装问题规避
    instance_name=ODRSZenith
    instance_db_name="invmirrordb"
    is_contain_db=`. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${EXEC_HOME}/../pyscripts/');import get_db_pass;print(get_db_pass.is_contain_db('${instance_name}', '${instance_db_name}', 'zenith'))" 2>&1`
    if [[ $? == "0" ]]
    then
        if [[ ${is_contain_db} == "true" ]]
        then
            echo "has db ${instance_db_name}, InvMirrorService needs to deal"
            InvMirrorService_ip=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global | grep InvMirrorService`
            if [[ ! -z ${InvMirrorService_ip} ]]
            then
                echo "InvMirrorService need stop"
                start_or_stop_app InvMirrorService invmirrorservice stopapp
            fi
            # 执行sql
            retry_times=8
            cd ${EXEC_HOME}/../plugins/invmirrorservice_sql
            for((i=1;i<=${retry_times};i++))
            do
                . /opt/oss/manager/bin/engr_profile.sh; bash migrate_common.sh
                result=$?
                if [[ "${result}" == "0" ]]
                then
                    echo "InvMirrorService exec sql successfully."
                    break
                else
                    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "InvMirrorService exec sql failed, retry_times: ${i}"
                    if [[ ${i} -eq ${retry_times} ]]
                    then
                        exit 1
                    fi
                    sleep 5
                fi
            done

            if [[ ! -z ${InvMirrorService_ip} ]]
            then
                echo "InvMirrorService need start"
                start_or_stop_app InvMirrorService invmirrorservice startapp
            fi

        else
            echo "does not have db ${instance_db_name}, InvMirrorService does not need to deal"
            exit 0
        fi
    else
        echo "is_contain_db exec failed"
        exit 1
    fi

}

main $@ >> ${log_file} 2>&1