#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
instance_name=${4}
db_name=${5}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}


function main()
{
    # 导入数据
    cd ${EXEC_HOME}/../exp_imp_data/
    bash export_data_common.sh ${instance_name} ${db_name}
    if [[ $? -ne 0 ]]
    then
        echo "[`date`] export data failed."
        exit 1
    else
        echo "[`date`] export data success."
    fi
}

main $@ >> ${log_file} 2>&1