#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main(){
    . /opt/oss/manager/bin/engr_profile.sh
    echo `date '+%Y-%m-%d %H:%M:%S'`[INFO]' Start to fix sub interface.'
    export SSL_ROOT=/opt/oss/manager/etc/ssl
    export CIPHER_ROOT=/opt/oss/manager/etc/cipher
    ${PYTHONHOME}/bin/python ${EXEC_HOME}/../pyscripts/fix_sub_interface.py
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "fix sub interface successfully"
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "fix sub interface failed"
        exit 1
    fi
}

main >> ${log_file} 2>&1