#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
log_dir=$(sh ${EXEC_HOME}/../get_log_dir.sh)
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main(){
    export_import_data_dir=${log_dir}/export_import_data
    export_import_data_zip=${log_dir}/exportImportData.zip
    if [[ -d ${export_import_data_dir} ]]
    then
        rm -rf ${export_import_data_dir}
        mkdir -p ${export_import_data_dir}
    fi

    if [[ -f ${export_import_data_zip} ]]
    then
        rm -rf ${export_import_data_zip}
    fi

    if [[ ! -z $(ls /opt/oss/export_data) ]]
    then
        cp -rf /opt/oss/export_data ${export_import_data_dir}
        rm -rf /opt/oss/export_data
    fi

    if [[ ! -z $(ls /opt/oss/export_data_log) ]]
    then
        cp -rf /opt/oss/export_data_log ${export_import_data_dir}
        rm -rf /opt/oss/export_data_log
    fi

    if [[ ! -z $(ls /opt/oss/import_data_log) ]]
    then
        cp -rf /opt/oss/import_data_log ${export_import_data_dir}
        rm -rf /opt/oss/import_data_log
    fi

    # -r递归，-q过程不输出屏幕, -o文件名
    cd ${log_dir}
    zip -rqo exportImportData.zip export_import_data
    rm -rf ${export_import_data_dir}

}

main $@ >> ${log_file} 2>&1