#!/bin/bash

tenant_name=${1}
log_file=${2}

# 此脚本用来规避CloudSOP R22C10之前的升级场景，并发发布接口失败，高版本接口unpublished问题
# 在OMP节点获取MinAPIGatewayService服务所在节点IP（多个,取一个节点执行即可）
NODEIP=$(bash /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -tenant ${tenant_name} -app MinAPIGatewayService -nodeip global | grep "MinAPIGatewayService" | awk -F " " '{print $6}' | sort | uniq |head -1)
echo "$(date "+%Y-%m-%d %H:%M:%S") execute in node : ${NODEIP}" >> ${log_file}

# 筛选出unpublished的服务并重新发布
ssh -tt ossadm@${NODEIP} -oStrictHostKeyChecking=no >> ${log_file} 2>&1 << cmdoff
    services=\`sudo -u ossuser sh /opt/oss/${tenant_name}/apps/MinAPIGatewayService/bin/apiHandler.sh -l | grep unpublished | awk '{print \$1}'\`
    for service in \${services}; do
        sudo -u ossuser sh /opt/oss/${tenant_name}/apps/MinAPIGatewayService/bin/apiHandler.sh -d \${service}
    done
    sudo -u ossuser sh /opt/oss/${tenant_name}/apps/MinAPIGatewayService/bin/apiHandler.sh -p
    exit
cmdoff

echo "$(date "+%Y-%m-%d %H:%M:%S") post_upgrade_MinAPIGatewayService.sh over." >> ${log_file}
