#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main(){
    sh ${EXEC_HOME}/post_upgrade_MinAPIGatewayService.sh ${tenant_name} ${log_file}
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo "post upgrade MinAPIGatewayService success"
    else
        echo "post upgrade MinAPIGatewayService failed"
        exit 1
    fi
}

main $@ >> ${log_file} 2>&1