#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){
    # 获取源版本和目标版本
    versions=$(sh ${EXEC_HOME}/get_version.sh ${upgrade_path})
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo "get src_version or des_version successfully."
    else
        echo "get src_version or des_version failed."
        exit 1
    fi
    versions_array=(${versions//,/ })
    src_version=${versions_array[0]}
    des_version=${versions_array[1]}
    echo "src_version: ${src_version}, des_version: ${des_version}"

    # 解决AAA升级导致的用户权限问题
    . /opt/oss/manager/bin/engr_profile.sh
    ${PYTHONHOME}/bin/python ${EXEC_HOME}/../pyscripts/l2l3_app_upgrade.py ${src_version} ${des_version}
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo "Resolving the User Rights Problem Caused by AAA Upgrade successfully."
    else
        echo "Resolving the User Rights Problem Caused by AAA Upgrade failed."
        exit 1
    fi
}

main $@ >> ${log_file} 2>&1