#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
temporary_dir=$(sh ${EXEC_HOME}/../get_temporary_dir.sh)
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){

    if [[ -f ${temporary_dir}/add_nic_flag.txt ]]
    then
        /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global | grep -w "NetconfClientService" | awk '{print $6}'| while read line
        do
            echo "restart NetconfClientService in $line"
            ssh ossadm@"$line" << remotessh
                /opt/oss/manager/agent/bin/ipmc_adm -cmd restartapp -app "NetconfClientService"
                exit
remotessh
        done
    fi

}

main $@ >> ${log_file} 2>&1