#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


get_dbip_port() {
    dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Master`
    if [ -z "$dbinfo" ]
    then
        dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"`
    fi
    MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
    port=`echo $dbinfo|awk '{print $7}'`
}

function main(){
    DB_TYPE="zenith"
    upgrade_path_array=(${upgrade_path//-/ })
    src_path=${upgrade_path_array[0]}
    result=$(echo ${src_path}| grep "V300R019C")
    if [ "${result}X" != "X" ]; then
        DB_TYPE="gauss"
    fi
    # 3.检查数据库大表业务面+管理面
    for instance_name_ip in `sudo -u dbuser ls /opt/${DB_TYPE}/data`
    do
    	instance_name_array=(${instance_name_ip//-/ })
    	instance_name=${instance_name_array[0]}
    	echo ${instance_name} >> ${log_file}
    	PRODUCT_TYPE="NCE"
    	if [ ${instance_name} == "managedbsvr" ]
    	then
    		PRODUCT_TYPE="manager"
    	fi
    	#运行函数：获取数据库ip,port, admin password
    	get_dbip_port $instance_name
    	if [[ -z "${MACHINE_IP}" ]]
    	then
    	    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "can not find info for $instance_name: skip"
    	    continue
    	fi

    	# 获取db_names
    	db_names=`. /opt/oss/manager/agent/bin/engr_profile.sh;cd ${EXEC_HOME}/../pyscripts;${PYTHONHOME}/bin/python get_db_names_for_precheck.py ${instance_name} ${MACHINE_IP} ${port} $DB_TYPE $PRODUCT_TYPE`
    	echo ${db_names} >> ${log_file}

        # get_db_info(取当前实例的第一个db_name)
        db_names_now_array=(${db_names//,/ })
        db_names_one_of_now=${db_names_now_array[0]}
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "db_names_one_of_now: ${db_names_one_of_now}"
        db_info=`. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${EXEC_HOME}/../pyscripts/');import get_db_pass;pec=get_db_pass.epc;fmt='';pec1=pec.getLogger('db_info');pec_s=pec.StreamHandler();pec_s.setFormatter(fmt);pec1.addHandler(pec_s);pec1.critical(get_db_pass.main('${instance_name}', '${db_names_one_of_now}', '${DB_TYPE}', '${PRODUCT_TYPE}'))" 2>&1`
        result=$?
        if [[ "${result}" == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get db_info successfully."
            result_array=(${db_info//,/ })
            adminPP=${result_array[2]}
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get db_info failed."
            exit 1
        fi

    	for db_name in ${db_names//,/ }
    	do
    		. /opt/oss/manager/agent/bin/engr_profile.sh; ${PYTHONHOME}/bin/python ${EXEC_HOME}/../pyscripts/get_big_table.py ${db_name} ${adminPP} ${MACHINE_IP} ${port} ${instance_name} ${DB_TYPE}
    		result=$?
    		if [[ "${result}" == "0" ]]
    		then
    			echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get get_big_table successfully." >> ${log_file}
    		else
    			echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get get_big_table failed." >> ${log_file}
    			exit 1
    		fi
    	done
    done
}

main $@ >> ${log_file} 2>&1