#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main(){
    # 检查管理面主备状态
    manager_db=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep managedbsvr|grep Master|awk '{print $3}'`
    if [ $manager_db != "managedbsvr-0-999" ]
    then
        bash /opt/oss/manager/apps/DBHASwitchService/bin/switchtool.sh -cmd switchover -instid managedbsvr-0-999@1-999 -newmaster managedbsvr-0-999
        if [ $? != 0 ]
        then
          echo "[ WARNING ]The status of the master and slave instances on the management plane is abnormal, failed to fix it."
          exit 1
        else
          echo "The status of the master and slave instances on the management plane was abnormal, already fix it."
          exit 0
        fi
    fi

}

main $@ 2>>${log_file}