#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
IPS=${4}
temporary_dir=$(sh ${EXEC_HOME}/../get_temporary_dir.sh)
temporary_path=${temporary_dir}/check_result
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main(){
    IPS_array=(${IPS//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        ssh ossadm@${ip} << EOF
            [[ ! -d ${temporary_path} ]] && mkdir -p ${temporary_path}
            rm -rf ${temporary_path}/check_sopuser_dir-${ip}.txt
            rm -rf ${temporary_path}/check_sopuser_file-${ip}.txt

            [[ -d /home/sopuser  ]] && echo "user /home/sopuser exists" > ${temporary_path}/check_sopuser_dir-${ip}.txt
            [[ -f /home/sopuser  ]] && echo "file /home/sopuser exists" > ${temporary_path}/check_sopuser_file-${ip}.txt
        exit
EOF
    done

    echo eheck_sopuser_end


}

main $@ >> ${log_file} 2>&1