#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
temporary_dir=$(sh ${EXEC_HOME}/../get_temporary_dir.sh)
temporary_path=${temporary_dir}/check_result
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main(){
    [[ ! -d ${temporary_path} ]] && mkdir -p ${temporary_path}
    result_name=${temporary_path}/check_package_result-127.0.0.1.txt
    if [[ -f ${temporary_path}/check_package_result-127.0.0.1.txt ]]
    then
        rm -rf ${result_name}
    fi

    cd ${EXEC_HOME}/../pyscripts
    is_ok=$(. /opt/oss/manager/agent/bin/engr_profile.sh;${PYTHONHOME}/bin/python -c "import repair;print(repair.main())")
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "check package successfully."
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "check package failed."
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "check package failed." > ${result_name}
    fi

    if [[ "${is_ok}" == "no" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "repair package failed."
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "repair package failed." > ${result_name}
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "repair package successfully."
    fi

    echo "check package end"


}

main $@ >> ${log_file} 2>&1