#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){

    gauss_dir=/opt/gauss/data
    sudo -s -u dbuser<<EOF
    for instance_name in \$(ls ${gauss_dir})
    do
        if [[ -d ${gauss_dir}/\${instance_name} ]]
        then
            if [[ ! -f ${gauss_dir}/\${instance_name}/postgresql.conf ]]
            then
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "not gauss instance dir: \${instance_name}"
                rm -rf ${gauss_dir}/\${instance_name}
            fi
        fi
    done
EOF

    slave_ip=`. /opt/oss/manager/agent/bin/engr_profile.sh;${PYTHONHOME}/bin/python -c "import sys;sys.path.append('${EXEC_HOME}/../pyscripts/');import get_ip_by_num;print(get_ip_by_num.get_ip('1'))"`
    if [[ $? == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get slave_ip successfully."
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get slave_ip failed."
        exit 1
    fi

    if [[ -n ${slave_ip} ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "deal gauss data in ${slave_ip}"
        ssh -o StrictHostKeyChecking=no ossadm@${slave_ip} sudo -s -u dbuser<<EOF
        for instance_name in \$(ls ${gauss_dir})
        do
            if [[ -d ${gauss_dir}/\${instance_name} ]]
            then
                if [[ ! -f ${gauss_dir}/\${instance_name}/postgresql.conf ]]
                then
                    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "not gauss instance dir: \${instance_name}"
                    rm -rf ${gauss_dir}/\${instance_name}
                fi
            fi
        done
EOF
    fi

    # R20C00备份前需要删除gauss
    . /opt/oss/manager/bin/engr_profile.sh;${PYTHONHOME}/bin/python ${EXEC_HOME}/../pyscripts/delete_gauss.py
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "Exec delete gauss successfully." >> ${log_file}
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "Exec delete gauss failed." >> ${log_file}
        exit 1
    fi
}

main $@ >> ${log_file} 2>&1