#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
IPS=${4}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){
    # 规避: 22.0 SPC100逻辑复制工具启动脚本（SPC100 和 SPC101需要规避，这两个版本脚本中含有 install_logicrep.log）
    # 极速升级预分发软件包，微服务目录会同时存在两个版本，获取APP_ROOT时会获取到新的版本，导致逻辑复制工具启动失败
    app_root=/opt/oss/${tenant_name}/apps/DTAgentService
    IPS_array=(${IPS//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        ssh ossadm@${ip} << EOF
             if [[ -d ${app_root} ]] && [[ -n \$(sudo -u ossuser cat ${app_root}/bin/logic_tool_start.sh | grep install_logicrep.log) ]]
             then
                 echo "modify file_name in ${ip}"
                 sudo -u ossuser sed -i '55 c\                  exit 0' ${app_root}/bin/logic_tool_start.sh
             fi
            exit
EOF
    done
}

main $@ >> ${log_file} 2>&1