#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
IPS=${4}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

temporary_dir=$(sh ${EXEC_HOME}/../get_temporary_dir.sh)
# 最终汇总结果路径
check_result_path=${temporary_dir}/check_result/check_result_summarized
# 各个节点的检查文件
check_path=${temporary_dir}/check_result
# ossuser专属目录
upgrade_dir_for_ossuser=/opt/oss/upgrade_dir_for_ossuser

function main(){
    IPS_array=(${IPS//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        ssh ossadm@${ip} << EOF
            [[ ! -d ${temporary_dir} ]] && mkdir -p ${temporary_dir}
            [[ ! -d ${upgrade_dir_for_ossuser} ]] && mkdir -p ${upgrade_dir_for_ossuser}
            chmod 770 ${upgrade_dir_for_ossuser}
        exit
EOF
    done

    # 各个节点的检查文件汇总路径
    if [[ -d ${check_path} ]]
    then
        rm -rf ${check_path}
    fi
    mkdir -p ${check_path}
    # 汇总检查结果路径设置
    if [[ -d ${check_result_path} ]]
    then
        rm -rf ${check_result_path}
    fi
    mkdir -p ${check_result_path}
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "make dir ${check_result_path} successfully."
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "make dir ${check_result_path} failed."
        exit 1
    fi
}

main $@ >> ${log_file} 2>&1